<?php
/*
Intense Template Name: Menu (One Column)
*/

$post = get_post(); 
$intense_custom_post = Intense_Custom_Post::get_metadata();

$header_tag = "h4";
$intense_post_type = $intense_custom_post['post_type'];
?>
<article class='intense col-lg-12 col-md-12 col-sm-12 col-xs-12 <?php echo esc_attr( $intense_custom_post['post_classes'] ); ?> intense_post nogutter' style='<?php echo esc_attr( $intense_custom_post['cancel_plugin_layout_style'] ); ?>' id='post-<?php echo $post->ID; ?>'>
	<?php echo $intense_custom_post['animation_wrapper_start']; ?>
		<div class="intense_single_menu_item" style="border-top: 1px dashed #cccccc; border-bottom: 1px dashed #cccccc; padding:5px;">
			<div class="intense row" style="padding-top: 0; padding-bottom: 0; margin-top: 0; margin-bottom: 0; ">
				<div class="intense col-lg-9 col-xs-12 col-sm-9 col-md-9">
					<?php if ( $intense_custom_post['show_images'] && !empty( intense_get_post_thumbnail_ids( $post->id ) ) ) { ?>
						<!-- Image -->
						<div>
							<div style='width:45px; float:left; display:block;'>
								<?php echo intense_get_template( '/custom-post/shared/post_media.php', array( 'size' => 'thumbnail', 'include_link' => 0, 'custom_post_image_field' => ( isset( $custom_post_image_field ) ? $custom_post_image_field : null ) ) ); ?>
							</div>
							<div style="padding-left:55px;">
								<?php echo intense_get_template( '/custom-post/shared/post_title.php', array( 'tag' => $header_tag, 'margin' => '5px 0' ) ); ?>
								
								<div class='entry-content' style="padding-bottom:5px;">
									<?php echo get_field('intense_menu_items_description'); ?>
								</div>
							</div>
							<div style="clear:both;"></div>
						</div>
					<?php } else { ?>
							<?php echo intense_get_template( '/custom-post/shared/post_title.php', array( 'tag' => $header_tag, 'margin' => '5px 0' ) ); ?>
							
							<div class='entry-content' style="padding-bottom:5px;">
								<?php echo get_field('intense_menu_items_description'); ?>
							</div>
					<?php } ?>
				</div>
				<div class="intense col-lg-3 col-xs-12 col-sm-3 col-md-3">
					<?php
						$rows = get_field('intense_menu_items_prices');
						if( $rows )
						{
							foreach( $rows as $row )
							{
								$item_price = '';
								$item_description = '';

								if ( !empty( $row['intense_menu_items_description'] ) ) {
									$item_description = '<em style="padding-right:30px;">' . $row['intense_menu_items_description'] . '</em>';
								}

								if ( !empty( $row['intense_menu_items_price'] ) ) {
									$item_price = '<' . $header_tag . ' class="entry-title" style="margin:5px 0 0 0; display:inline-block;">' . $row['intense_menu_items_price'] . '</' . $header_tag . '><br />';
								}

								echo '<div style="width:100%;""><div style="float:right;">' . $item_description . $item_price . '</div><div style="clear:both;"></div></div>';
							}
						}
					?>
				</div>
			</div>
		</div>
	<?php echo $intense_custom_post['animation_wrapper_end']; ?>
</article>