<?php
/**
 * Order details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if (! defined ( 'ABSPATH' )) {
	exit ();
}

$order = wc_get_order ( $order_id );

//$payment_method_title=get_post_meta( $order_id, '_payment_method_title', TRUE );
$payment_method=$order->get_payment_method();

$show_purchase_note = $order->has_status ( apply_filters ( 'woocommerce_purchase_note_order_statuses', array (
		'completed',
		'processing' 
 ) ) );
$show_customer_details = is_user_logged_in () && $order->get_user_id () === get_current_user_id ();
$orderDetails = new WC_Order( $order_id );

?>

 <style>
 .order-summary-head{
	 background: #15154e;
    color: #fff ! important;
    padding: 12px 0;
    font-weight: bold;
    font-size: 21px ! important;
	    text-align: center;
 }
 .order-phone{
	 color:#fff ! important;
 }
.backButton {
	background: #337ab7;
	border: none;
	width: 100px;
	font-size: 20px;
	border-radius: 9px;
	height: 56px;
	margin-left: 50px;
	color: white;
	font-weight: bold;
}

.fontSize16px {
	font-size: 16px;
}

.details {
	margin: 10px 0px;
	font-size: 20px;
}

.fieldNamesColor {
	color: #01aef0 !important;
}

.yourDetails, .coverage {
	width: 48%;
	float: left;
	padding-right: 20px;
	margin-bottom: 10px;
}

.coveargeBorderLeft {
	border-left: 2px solid #22aef0;
}

.marginLeft20px {
	margin-left: 20px;
}

.checkOutPageUserInfo {
	margin-top: 10px;
	margin-bottom: 10px;
	background-color: #15154e;
}

.checkOutPageUserInfo p {
	padding: 3px 38px 5px 23px;
	color: white !important;
}

.paymentDetailsSectionInfo {
	margin-top: 10px;
	margin-bottom: 10px;
}

.paymentDetailsSectionInfo p {
	padding: 3px 38px 5px 23px;
}

.backButtonDiv {
	float: left;
	width: 100%;
}
.horizontalLine{
	 width: 100%;
	border: 1px solid #22aef0;
	height: 0px; 
}
@media only screen and (min-device-width : 400px) and (max-device-width
	: 768px) {
	.yourDetails {
		width: 100% !important;
	}
	.coveargeBorderLeft {
		    margin-bottom: 10px;
		border-left: 0px;
	}
	.yourPaymentDetails {
		width: 100% !important;
	}
	.coverage {
		min-height: 410px;
		width: 100%;
		float: none;
	}
}
</style> 

<section class="woocommerce-order-details">
	<!-- This is custom my code -->

	<div class="checkOutPageUserInfo">
		<p>Please check your details below carefully. Incorrect information provided can result in your claim being rejected in the future. If any details are incorrect, please contact us on <a href="tel:03333449669" class="order-phone">03333 449 669 </a>immediately.</p>
	</div>
	
	<?php
	$customer_id = get_current_user_id();
	?>
	<div class="yourDetails">
		<h2 class="woocommerce-order-details__title"><?php _e( 'Your Details', 'woocommerce' ); ?></h2>
		<table>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Name</span></td>
				<td><span>: <?php echo $order->get_billing_first_name().' '.$order->get_billing_last_name();?></span></td>
			</tr>
			<?php if ( get_post_meta( $order_id, 'billing_dob', true ) !=null ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Date Of Birth</span></td>
				<td><span>: <?php echo  get_post_meta( $order_id, 'billing_dob', true );?></span></td>
			</tr>
			<?php endif; ?>
			<?php if ( $order->get_billing_email() ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Email address</span></td>
				<td><span>: <?php echo esc_html( $order->get_billing_email() ); ?></span></td>
			</tr>
			<?php endif; ?>
			<?php if ( $order->get_billing_phone() ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Contact Number</span></td>
				<td><span>: <?php echo esc_html( $order->get_billing_phone() ); ?></span></td>
			</tr>
			<?php endif; ?>
			<?php if ( $order->get_formatted_billing_address() ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Address</span></td>
				<td><span>: <?php echo ( $address = $order->get_formatted_billing_address() ) ? $address : __( 'N/A', 'woocommerce' ); ?></span></td>
			</tr>
			
			<?php endif; ?>
			<?php if ( get_post_meta( $order_id, 'billing_password', true )!=null ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Password</span></td>
				<td><span>: <?php echo get_post_meta( $order_id, 'billing_password', true );?></span></td>
			</tr>
			<?php endif; ?>
			
			<?php if ( get_post_meta( $order_id, 'policy_start_date', true )!=null ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Policy start date</span></td>
				<td><span>: <?php echo get_post_meta( $order_id, 'policy_start_date', true );?></span></td>
			</tr>
			<?php endif; ?>
			
			<?php if(get_post_meta( $order_id, 'billing_confirm_items', true )!="on"){?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Any existing faults confirmed</span></td>
				<td><span>: Yes</span></td>
			</tr>
			<?php }else{ ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Any existing faults confirmed</span></td>
				<td><span>: No</span></td>
			</tr>
 			<?php }?>
			
			<?php if(get_post_meta( $order_id, 'payment_date', true )!=null){?>
			
			<?php if (get_post_meta( $order_id, 'payment_date', true )!=null ){ ?>
			
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Payment start date</span></td>
				<td><span>: <?php echo get_post_meta( $order_id, 'payment_date', true );?></span></td>
			</tr>
			<?php } ?>
			
			<?php }else { ?>
			
			<?php if ( get_post_meta( $order_id, 'policy_start_date', true )!=null ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Payment start date</span></td>
				<td><span>: <?php echo get_post_meta( $order_id, 'payment_start_date', true );?></span></td>
			</tr>
			<?php endif; ?>
			
			<?php } ?>
			
			<?php if ( get_post_meta( $order_id, 'terms_and_conditions', true ) =="on" ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">I’ve read and accept the T&C's</span></td>
				<td><span>: Yes</span></td>
			</tr>
			<?php endif; ?>
		
			<?php if ( get_post_meta( $order_id, 'terms_and_conditions', true ) !="on" ) : ?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">I’ve read and accept the T&C's</span></td>
				<td><span>: No</span></td>
			</tr>
			<?php endif; ?>
			
		</table>
	</div>
	
	<?php
	
	 $order_id=$order->get_order_number();
	 $order = new WC_Order( $order_id );
	 $items = $order->get_items();
	
?>
	
	<div class="coverage coveargeBorderLeft" style="min-height: 575px;">
		<h2 class="woocommerce-order-details__title marginLeft20px"><?php _e( 'Your Coverage', 'woocommerce' ); ?></h2>
<?php   
		 foreach ( $order->get_items () as $item_id => $item ) {
	
	?>
			
		<table class="marginLeft20px">
			<tr>
				<td style="width: 48%;"><span class="fieldNamesColor fontSize16px">Your Item</span></td>
				<td><span>: <?php echo $item['name']; ?></span></td>
			</tr>
			<?php if(wc_get_order_item_meta( $item_id, 'Model', $single = true )!=null){?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Model</span></td>
				<td><span>: <?php echo wc_get_order_item_meta( $item_id, 'Model', $single = true ); ?></span></td>
			</tr>
			<?php }?>
			<?php if(wc_get_order_item_meta( $item_id, 'make', $single = true )!=null){?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Make</span></td>
				<td><span>: <?php echo wc_get_order_item_meta( $item_id, 'make', $single = true );?></span></td>
			</tr>
			<?php }?>
			<?php if(wc_get_order_item_meta( $item_id, 'Enter other make', $single = true )!=null){?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Other make</span></td>
				<td><span>: <?php echo wc_get_order_item_meta( $item_id, 'Enter other make', $single = true );?></span></td>
			</tr>
			<?php }?>
			<!-- serial number -->
			<?php if(wc_get_order_item_meta( $item_id, 'Serial Number', $single = true )!=null){?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Serial Number</span></td>
				<td><span>: <?php echo wc_get_order_item_meta( $item_id, 'Serial Number', $single = true );?></span></td>
			</tr>
			<?php }?>
			
			<?php if(wc_get_order_item_meta( $item_id, 'Age of Item', $single = true )!=null){?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Age Of Item</span></td>
				<td><span>: <?php echo wc_get_order_item_meta( $item_id, 'Age of Item', $single = true );?></span></td>
			</tr>
			<?php }?>
			
			<?php if(wc_get_order_item_meta( $item_id, 'age-of-item', $single = true )!=null){?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Age Of Item</span></td>
				<td><span>: <?php echo wc_get_order_item_meta( $item_id, 'age-of-item', $single = true );?></span></td>
			</tr>
			<?php }?>
			<tr>
				<td><span class="fieldNamesColor fontSize16px">Purchase Value</span></td>
				<td><span>: <?php echo $item['subtotal']; ?></span></td>
			</tr>
		</table>
		
<?php }?>

	</div>
	
	<?php
			foreach ( $order->get_order_item_totals () as $key => $total ) {
				?>
					<?php
				if ($total ['label'] == "Yearly:") {
					$yearly = $total ['label'];
				}
			}?>
<hr class="horizontalLine">
	<h2 class="woocommerce-order-details__title">Your Payment Details</h2>
	<div class="paymentDetailsSectionInfo">
		<!--<p>You will be paying <?php
			foreach ( $order->get_order_item_totals () as $key => $total ) {
				?>
<?php echo $total['value']; ?>
			<?php }?>
				every <?php if($yearly == "Yearly:"){?>yearly <?php }else{?> monthly<?php }?>. Your fist payment will be on
			20/11/2017 with next payment on 20/12/2017. Payment will continue to
			be taken from your account on a <?php if($yearly == "Yearly:"){?>yearly <?php }else{?> monthly <?php }?>basis until your policy has
			been cancelled.</p>-->
	</div>


	<div style="float: left;" class="yourPaymentDetails">
		<table>
		<?php if($yearly!="Yearly:"){?>
			<tr>
				<td class="fieldNamesColor fontSize16px">Payment Schedule</td>
				<td>: Amount is paid every month</td>
			</tr>
			<?php }else{?>
			<tr>
				<td class="fieldNamesColor fontSize16px">Payment Schedule</td>
				<td>: Amount is paid every Year</td>
			</tr>
			<?php } ?>
			
			<?php
			foreach ( $order->get_order_item_totals () as $key => $total ) {
			
				if($total['value']!=null && $total['label']!=null){
				if($total['value']!="Free shipping" && $total['label']!="Subtotal:" && $total['label']!="Yearly:"){
				?>
					
				<tr>
				<td class="fieldNamesColor fontSize16px"><?php  if($total['label']=="Payment method:"){ ?>Payment method <?php }else if ($total['label']=="Total:"){?>Total<?php }?></td>
				<td>: <?php echo $total['value']; ?></td>
			    </tr>
				<?php
				if ($total ['label'] == "Yearly:") {
					$yearly = $total ['label'];
				}}}
			}
			?>
			
		</table>
	</div>
	</div>

	<!-- Ends This is custom my code -->
</section>

<!-- Google Code for Web sale Conversion Page -->
<script type="text/javascript">
/* <![CDATA[ */
var google_conversion_id = 846248016;
var google_conversion_label = "LfapCI7lhXYQ0PDCkwM";
var google_remarketing_only = false;
/* ]]> */
</script>
<script type="text/javascript" src="//www.googleadservices.com/pagead/conversion.js">
</script>
<noscript>
<div style="display:inline;">
<img height="1" width="1" style="border-style:none;" alt="" src="//www.googleadservices.com/pagead/conversion/846248016/?label=LfapCI7lhXYQ0PDCkwM&amp;guid=ON&amp;script=0"/>
</div>
</noscript>