<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
//wc_print_notices();
?>


<div class="cart-header"><?php if ( is_active_sidebar( 'sidebar-woo' )  ) : ?><?php dynamic_sidebar( 'sidebar-woo' ); ?><?php endif; ?></div>
<?php do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) );
	return;
}

?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

	<?php if ( $checkout->get_checkout_fields() ) : ?>

		<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

		<div class="col2-set" id="customer_details">
			<div class="col-1">

				<!--- Billing details Start  -->
				<div class="woocommerce-billing-fields">
					<?php if ( wc_ship_to_billing_address_only() && WC()->cart->needs_shipping() ) : ?>

						<h3><?php _e( 'Billing &amp; Shipping', 'woocommerce' ); ?></h3>

					<?php else : ?>

						<h3><?php _e( 'Billing details', 'woocommerce' ); ?></h3>

					<?php endif; ?>

					<?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>

					<div class="woocommerce-billing-fields__field-wrapper">
						<?php foreach ( $checkout->get_checkout_fields( 'billing' ) as $key => $field ) : ?>
							<?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
						<?php endforeach; ?>
					</div>

					<?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>
				</div>
			</div>
			<!--- Billing details end -->


			<div class="col-2">
			
			

<table class="shop_table">
	
	<tbody>
							<tr class="cart_item">
						<td class="product-name" style="background-color: rgb(43, 103, 11); color: #fff; text-align: center;"  width="50%">
							<div id="mm"><b>Monthly</b> <br> <?php wc_cart_totals_subtotal_html(); ?> 
							<br><span style="font-size:11px;">Saving 10% (60p) </span><small style="font-size:9px;display:block">Including Online Discount</small></div>
							<div id="yy"><b>Annualy</b> <br> <?php global $woocommerce; 
								 $percentage = 10;
								$surcharge =  $woocommerce->cart->subtotal  * $percentage; 
								echo "£".number_format($surcharge,'2');
							 ?> <br> <span style="font-size:11px;">Saving 10% (£ 7.19) </span><small style="font-size:9px;display:block">Including Online Discount</small></div>
						</td>
						<td class="product-total">	<div id="inline_content"> <input name="billing_cycle" id="billing_cycle" value="Monthly" class="select" type="radio"  >Monthly
						<br> <input name="billing_cycle" id="billing_cycle" value="Yearly" class="select" type="radio"  >Annualy	</div>		</td>
					</tr>
						</tbody>

</table>
				<h3 id="order_review_heading"><?php _e( 'Your order', 'woocommerce' ); ?></h3>
										<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

										<div id="order_review" class="woocommerce-checkout-review-order">
											<?php do_action( 'woocommerce_checkout_order_review' ); ?>
										</div>

										<?php  do_action( 'woocommerce_checkout_after_order_review' ); ?>
				<!--Shopping details ends-->
			</div>
		</div>

		<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

	<?php endif; ?>

	



</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
