<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="woocommerce-order">

	<?php if ( $order ) : ?>

		<?php if ( $order->has_status( 'failed' ) ) : ?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php _e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php _e( 'Pay', 'woocommerce' ) ?></a>
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php _e( 'My account', 'woocommerce' ); ?></a>
				<?php endif; ?>
			</p>

		<?php else : ?>

			<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'woocommerce' ), $order ); ?></p>
<!---->
			<?php if($order->get_payment_method()=="custom"){ ?>
<!-- congratulations -->

<div class="wrp cnt">
	<section class="bSe fullWidth">
		<article>
			<div class="awr ">
				<h1 class="entry-title"></h1>
				<div id="tve_flt" class="tve_flt">
					<div id="tve_editor" class="tve_shortcode_editor">
						<div style="width: 120px;"
							class="thrv_wrapper tve_image_caption aligncenter">
							<span class="tve_image_frame"><img class="tve_image" alt=""
								style="width: 120px;"
								src="//smart-sure.com/wp-content/uploads/2017/09/check-mark-11-512.gif"
								width="120" height="120" data-attachment-id="1928"></span>
						</div>
						<h1 class="tve_p_center" style="text-align: center;">Congratulations and welcome to
							Smart-Sure</h1>
						<div class="thrv_wrapper thrv_custom_html_shortcode" style="">
							<div style="text-align: center;">
								<p>
									Your details are currently being processed by our system.<br>
									Your policy documents will be posted to the address provided
									within the next 5 days.<br> If your policy documents are not
									with you in 5 days, don’t worry, you are still covered.
								</p>
								Please remember you can always contact us on <a href="tel:03333449669" class="">03333 449 669 </a> or
								via our <a href="../contact">Contact page</a>
								<h4>Have a great day!</h4>
								<p>
									Click here to return to <a href="../">Homepage</a>
								</p>
							</div>
						</div>
					</div>
				</div>
				<div class="clear"></div>
				<div class="clear"></div>
			</div>
		</article>
	</section>
	<div class="clear"></div>
</div>


<!-- end of congratulations -->
<?php } ?>
			<!---->
			<p class="order-summary-head"> Below is a summary of your cover</p>
			<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

				<li class="woocommerce-order-overview__order order">
					<?php _e( 'Order number:', 'woocommerce' ); ?>
					<strong><?php echo $order->get_order_number(); ?></strong>
				</li>

				<li class="woocommerce-order-overview__date date">
					<?php _e( 'Date:', 'woocommerce' ); ?>
					<strong><?php echo wc_format_datetime( $order->get_date_created() ); ?></strong>
				</li>

				<li class="woocommerce-order-overview__total total">
					<?php _e( 'Total:', 'woocommerce' ); ?>
					<strong><?php echo $order->get_formatted_order_total(); ?></strong>
				</li>

				<?php if ( $order->get_payment_method_title() ) : ?>

				<li class="woocommerce-order-overview__payment-method method">
					<?php _e( 'Payment method:', 'woocommerce' ); ?>
					<strong><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></strong>
				</li>

				<?php endif; ?>

			</ul>

		<?php endif; ?>

		<?php do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() ); ?>
		<?php do_action( 'woocommerce_thankyou', $order->get_id() ); ?>

	<?php else : ?>

		<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'woocommerce' ), null ); ?></p>

	<?php endif; ?>

</div>
