<?php
/**
 * Order details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if (! defined ( 'ABSPATH' )) {
	exit ();
}

$order = wc_get_order ( $order_id );

$show_purchase_note = $order->has_status ( apply_filters ( 'woocommerce_purchase_note_order_statuses', array (
		'completed',
		'processing' 
) ) );
$show_customer_details = is_user_logged_in () && $order->get_user_id () === get_current_user_id ();

?>

<section class="woocommerce-order-details">
<!-- This is custom my code -->
	<div style="width: 50%; float: left;">
		<h2 class="woocommerce-order-details__title"><?php _e( 'Your Details', 'woocommerce' ); ?></h2>
	</div>
	
	<div style="width: 50%">
		<h2 class="woocommerce-order-details__title"><?php _e( 'Your Coverage', 'woocommerce' ); ?></h2>
	</div>

<!-- Ends This is custom my code -->
</section>

<section class="woocommerce-order-details">

	<table>
		<tr>
			<td style="width: 50%"><h2 class="woocommerce-order-details__title"><?php _e( 'Your Details', 'woocommerce' ); ?></h2></td>
			<td style="width: 50%"><h2 class="woocommerce-order-details__title"><?php _e( 'Your Coverage', 'woocommerce' ); ?></h2></td>
		</tr>


		<tr>
			<td
				style="vertical-align: top !important; border-right: 5px solid #00aeef !important;">

<?php if ( ! wc_ship_to_billing_address_only() && $order->needs_shipping_address() ) : ?>

	<section
					class="woocommerce-columns woocommerce-columns--2 woocommerce-columns--addresses col2-set addresses">

					<div
						class="woocommerce-column woocommerce-column--1 woocommerce-column--billing-address col-1">

			<?php endif; ?>

			<h3 class="woocommerce-column__title"
							style="margin: 0px; padding: 0px;"><?php _e( 'Billing address', 'woocommerce' ); ?></h3>

						<address>
				<?php echo ( $address = $order->get_formatted_billing_address() ) ? $address : __( 'N/A', 'woocommerce' ); ?>
			</address>

			<?php if ( ! wc_ship_to_billing_address_only() && $order->needs_shipping_address() ) : ?>

		</div>
					<!-- /.col-1 -->

					<div
						class="woocommerce-column woocommerce-column--2 woocommerce-column--shipping-address col-2">

						<h3 class="woocommerce-column__title"><?php _e( 'Shipping address', 'woocommerce' ); ?></h3>

						<address>
				<?php echo ( $address = $order->get_formatted_shipping_address() ) ? $address : __( 'N/A', 'woocommerce' ); ?>
			</address>

					</div>
					<!-- /.col-2 -->

				</section> <!-- /.col2-set -->

	<?php endif; ?>



	<table
					class="woocommerce-table woocommerce-table--customer-details shop_table customer_details">
		<?php if ( $order->get_customer_note() ) : ?>
			<tr>
						<th><?php _e( 'Note:', 'woocommerce' ); ?></th>
						<td><?php echo wptexturize( $order->get_customer_note() ); ?></td>
					</tr>
		<?php endif; ?>

		<?php if ( $order->get_billing_email() ) : ?>
			<tr>
						<th><?php _e( 'Email:', 'woocommerce' ); ?></th>
						<td><?php echo esc_html( $order->get_billing_email() ); ?></td>
					</tr>
		<?php endif; ?>

		<?php if ( $order->get_billing_phone() ) : ?>
			<tr>
						<th><?php _e( 'Phone:', 'woocommerce' ); ?></th>
						<td><?php echo esc_html( $order->get_billing_phone() ); ?></td>
					</tr>
		<?php endif; ?>

		<?php do_action( 'woocommerce_order_details_after_customer_details', $order ); ?>

	</table>



			</td>

			<!-- &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& seperator &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& -->
			<td>

				<table
					class="woocommerce-table woocommerce-table--order-details shop_table order_details">

					<!-- 	<thead>
			<tr>
				<th class="woocommerce-table__product-name product-name"><?php _e( 'Product', 'woocommerce' ); ?></th>
				<th class="woocommerce-table__product-table product-total"><?php _e( 'Total', 'woocommerce' ); ?></th>
			</tr>
		</thead> -->

					<tbody>
			<?php
			foreach ( $order->get_items () as $item_id => $item ) {
				$product = apply_filters ( 'woocommerce_order_item_product', $item->get_product (), $item );
				
				wc_get_template ( 'order/order-details-item.php', array (
						'order' => $order,
						'item_id' => $item_id,
						'item' => $item,
						'show_purchase_note' => $show_purchase_note,
						'purchase_note' => $product ? $product->get_purchase_note () : '',
						'product' => $product 
				) );
			}
			?>
			<?php do_action( 'woocommerce_order_items_table', $order ); ?>
		</tbody>


				</table>
	<?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>

</td>
		</tr>

		<tr>
			<td colspan="2">

				<h2 class="woocommerce-order-details__title"><?php _e( 'Your Payment Details', 'woocommerce' ); ?></h2>

				<table style="width: 60%;">

					<tfoot>
			<?php
			foreach ( $order->get_order_item_totals () as $key => $total ) {
				?>
					<tr>
							<th scope="row"><?php echo $total['label']; ?></th>
							<td><?php echo $total['value']; ?></td>
						</tr>
					<?php
				if ($total ['label'] == "Yearly:") {
					$yearly = $total ['label'];
				}
			
			}
			?>
			<?php if($yearly!="Yearly:"){?>
					<tr>
							<th scope="row">Payment Schedule:</th>
							<td>Amount is paid every month</td>
						</tr>	
			<?php } else {?>
					<tr>
							<th scope="row">Payment Schedule:</th>
							<td>Amount is paid every Year</td>
						</tr>	
			<?php } ?>

		</tfoot>
				</table>

			</td>
		</tr>




	</table>
	<!-- 
	

	

	<?php if ( $show_customer_details ) : ?>
		<?php wc_get_template( 'order/order-details-customer.php', array( 'order' => $order ) ); ?>
	<?php endif; ?>
 -->
</section>
